package gov.va.med.mhv.usermgmt.integration.service.delegate;

import java.rmi.RemoteException;

import javax.ejb.CreateException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.tigris.atlas.service.ejb.EjbUtil;

import gov.va.med.mhv.core.util.Precondition;
import gov.va.med.mhv.integration.registry.services.ejb.PatientCorrelationServiceRemote;
import gov.va.med.mhv.integration.registry.services.ejb.PatientCorrelationServiceRemoteHome;
import gov.va.med.mhv.integration.registry.transfer.Patient;
import gov.va.med.mhv.integration.registry.transfer.Status;
import gov.va.med.mhv.integration.registry.transfer.StatusType;
import gov.va.med.mhv.usermgmt.util.MessageKeys;

/**
 * Service delegate for the Patient service
 */
public class PatientCorrelationServiceDelegateImpl 
    implements PatientCorrelationServiceDelegate
{

	private static Log log = LogFactory.getLog(
        PatientCorrelationServiceDelegateImpl.class);
    
                
    
	/**
	 * Create a new delegate.
	 */
	public PatientCorrelationServiceDelegateImpl() {
		super();
	}



    /* (non-Javadoc)
     * @see gov.va.med.mhv.usermgmt.integration.service.delegate.
     * PatientCorrelationServiceDelegate#correlatePatient(
     * gov.va.med.mhv.integration.registry.transfer.Patient)
     */
    public Status correlatePatient(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        Status status = null;
        try {
            PatientCorrelationServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.correlatePatient(patient)
                : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status correlatePatient(Patient patient)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }

    /* (non-Javadoc)
     * @see gov.va.med.mhv.usermgmt.integration.service.delegate.
     * PatientCorrelationServiceDelegate#uncorrelatePatient(
     * gov.va.med.mhv.integration.registry.transfer.Patient)
     */
    public Status uncorrelatePatient(Patient patient) {
        Precondition.assertNotNull("patient", patient);
        Status status = null;
        try {
            PatientCorrelationServiceRemote remote = getRemoteService();
            status = (remote != null) ? remote.uncorrelatePatient(patient)
                : (Status) serverUnavailable();
            
        } catch (RemoteException re) {
            String methodName = 
                "Status uncorrelatePatient(Patient patient)";
            status = handleRemoteException(methodName, re);
            
        }
        return status;
    }


	/**
	 * Gets the remote stub for a session bean call
	 * @return The <tt>PatientServiceRemote</tt> to use to perform a 
     * remote call
	 */
	protected PatientCorrelationServiceRemote getRemoteService() {
        PatientCorrelationServiceRemote remote = null;
		Context ic = null;
		Object o = null;
		try {		
			ic = new InitialContext();
			o = PortableRemoteObject.narrow(ic.lookup(
                PatientCorrelationServiceRemoteHome.JNDI_NAME),
				PatientCorrelationServiceRemoteHome.class);
			PatientCorrelationServiceRemoteHome home = 
                (PatientCorrelationServiceRemoteHome)o;
			remote = home.create();
		} catch (ClassCastException cce) {
			if (log.isErrorEnabled()) {				
				log.error("A class cast exception occurred looking up service "
                    + "\"PatientCorrelationService\"'s remote stub." 
                    + " Expected \"PatientCorrelationService\", but returned \"" 
                    + o.getClass() + "\"", cce);		
			}
			
		} catch (RemoteException re) {
			if (log.isErrorEnabled()) {
				log.error("A remote exception occurred looking up service " 
                    + "\"PatientCorrelationService\"'s remote stub", re);			
			}
			
		} catch (NamingException ne) {
			if (log.isErrorEnabled()) {
				log.error("A naming exception occurred looking up service "
                    + "\"PatientCorrelationService\"'s remote stub", ne);			
			}
			
		} catch (CreateException ce) {
			if (log.isErrorEnabled()) {
				log.error("A creation exception occurred looking up service "
                    + "\"PatientCorrelationService\"'s remote stub", ce);			
			}
			
		} finally {
			EjbUtil.closeContext(ic);
			
		}

		return remote;
	}
 
	private Status handleRemoteException(String methodName, 
        RemoteException re) 
    {
		if (log.isErrorEnabled()) {
			log.error("Exception occurred during " + methodName, re);
			
		}
        Status status = new Status();
        status.setStatus(StatusType.Error);
        status.setStatusDescription(MessageKeys.UNKNOWN_EXCEPTION_OCCURRED);
		return status;
	}
	
	private Status serverUnavailable() {
		if (log.isErrorEnabled()) {
			log.error("\"PatientIdentityServiceRemote\" could not be found!");
			
		}
        Status status = new Status();
        status.setStatus(StatusType.Error);
        status.setStatusDescription("server.unavailable");
        return status;
	}

	
}